package com.atlassian.oauth2.provider.api.event.token;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import lombok.EqualsAndHashCode;

@EventName("plugins.oauth2.provider.token.created")
@EqualsAndHashCode
public class TokenCreatedEvent extends TokenEvent {
    private final RefreshToken refreshToken;

    public TokenCreatedEvent(final String clientId, final RefreshToken refreshToken) {
        super(clientId, refreshToken.getUserKey());
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return refreshToken.getScope().getName();
    }

    public int getRefreshCount() {
        return refreshToken.getRefreshCount();
    }
}
