package com.atlassian.oauth2.provider.api.event.client;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.oauth2.provider.api.client.Client;

@EventName("plugins.oauth2.provider.client.deleted")
public class ClientConfigurationDeletedEvent extends ClientConfigurationEvent {

    public ClientConfigurationDeletedEvent(final Client oldClient) {
        super(oldClient, null);
    }

    public String getScope() {
        return oldClient.getScope().getName();
    }
}
