package com.atlassian.oauth2.provider.api.event.client;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.oauth2.provider.api.client.Client;

@EventName("plugins.oauth2.provider.client.creation")
public class ClientConfigurationCreatedEvent extends ClientConfigurationEvent {

    public ClientConfigurationCreatedEvent(final Client newClient) {
        super(null, newClient);
    }

    public String getScope() {
        return newClient.getScope().getName();
    }
}
