package com.atlassian.oauth2.provider.api.event.authorization;

import com.atlassian.oauth2.provider.api.authorization.Authorization;
import lombok.Data;
import lombok.NonNull;

import com.atlassian.analytics.api.annotations.EventName;

@Data
@EventName("plugins.oauth2.provider.client.authorization")
public class ClientAuthorizationEvent {

    @NonNull
    private final Authorization authorization;

    public String getScope() {
        return authorization.getScope().getName();
    }
}
