package com.atlassian.oauth2.provider.api.client.dao;

import com.atlassian.oauth2.provider.api.client.Client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public interface ClientDao {

    @Nonnull
    Client create(@Nonnull Client clientEntity);

    Optional<Client> updateClient(@Nonnull String id,
                                  String name,
                                  String scope,
                                  @Nonnull List<String> redirectUris);

    Optional<Client> resetClientSecret(@Nonnull String clientId, @Nonnull String regeneratedClientSecret);

    Optional<Client> removeById(@Nonnull String id);

    boolean isClientNameUnique(@Nullable String id, @Nonnull String name);

    @Nonnull
    List<Client> list();

    @Nonnull
    Optional<Client> getById(@Nonnull String id);

    @Nonnull
    Optional<Client> getByClientId(@Nonnull String id);

    @Nonnull
    Optional<String> getClientIdById(@Nonnull String id);
}
