/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.util.concurrent;

import com.atlassian.oauth2.client.util.properties.SystemProperty;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class StripedMonitors<T> {
    private final Object[] stripes;

    public StripedMonitors() {
        this(SystemProperty.DEFAULT_MONITOR_STRIPE_COUNT.getValue());
    }

    public StripedMonitors(int stripeCount) {
        this.stripes = IntStream.range(0, stripeCount).mapToObj(i -> new Object()).toArray();
    }

    @Nonnull
    public Object getMonitor(T key) {
        return this.stripes[Math.floorMod(key.hashCode(), this.stripes.length)];
    }
}

