/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.client.lib.flow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.IdGenerator;
import com.atlassian.oauth2.client.api.ClientConfiguration;
import com.atlassian.oauth2.client.api.ClientToken;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestCompletedEvent;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestStartedEvent;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequest;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequestError;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequestService;
import com.atlassian.oauth2.client.api.lib.flow.FlowResult;
import com.atlassian.oauth2.client.lib.flow.FlowRequestData;
import com.atlassian.oauth2.client.lib.flow.FlowRequestImpl;
import com.atlassian.oauth2.client.lib.flow.FlowResultImpl;
import com.atlassian.oauth2.client.lib.flow.RedirectUrlResolver;
import com.atlassian.oauth2.client.lib.flow.ServletFlowRequestService;
import com.atlassian.oauth2.client.lib.flow.store.SessionStore;
import com.atlassian.oauth2.client.util.HttpsValidator;
import com.atlassian.oauth2.client.util.concurrent.StripedMonitors;
import com.atlassian.oauth2.client.util.properties.SystemProperty;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBasedFlowRequestService
implements FlowRequestService,
ServletFlowRequestService {
    private static final Logger logger = LoggerFactory.getLogger(SessionBasedFlowRequestService.class);
    private static final String COMMON_STORE_PREFIX = "com.atlassian.oauth2.client.lib.flow.SessionBasedFlowRequestService";
    private final RedirectUrlResolver redirectUrlResolver;
    private final IdGenerator idGenerator;
    private final IdGenerator stateGenerator;
    private final HttpsValidator httpsValidator;
    private final EventPublisher eventPublisher;
    private final SessionStore<FlowRequestData> requestByIdStore;
    private final SessionStore<FlowRequestData> requestByStateStore;
    private final SessionStore<FlowResultImpl> resultByIdStore;
    private final SessionStore<FlowState> flowStateByIdStore;
    private final StripedMonitors monitors = new StripedMonitors();

    public SessionBasedFlowRequestService(@Nonnull RedirectUrlResolver redirectUrlResolver, @Nonnull IdGenerator idGenerator, @Nonnull IdGenerator stateGenerator, @Nonnull HttpsValidator httpsValidator, @Nonnull Clock clock, @Nonnull EventPublisher eventPublisher) {
        this.redirectUrlResolver = redirectUrlResolver;
        this.idGenerator = idGenerator;
        this.stateGenerator = stateGenerator;
        this.httpsValidator = httpsValidator;
        this.eventPublisher = eventPublisher;
        Duration maxClockSkew = SystemProperty.MAX_CLOCK_SKEW.getValue();
        Duration maxClientDelay = maxClockSkew.plus(SystemProperty.MAX_CLIENT_DELAY.getValue());
        Duration maxOauthFlowDelay = maxClockSkew.plus(SystemProperty.MAX_SERVER_DELAY.getValue());
        this.requestByIdStore = new SessionStore("com.atlassian.oauth2.client.lib.flow.SessionBasedFlowRequestService.requestById", clock, maxClientDelay);
        this.requestByStateStore = new SessionStore("com.atlassian.oauth2.client.lib.flow.SessionBasedFlowRequestService.requestByState", clock, maxOauthFlowDelay);
        this.resultByIdStore = new SessionStore("com.atlassian.oauth2.client.lib.flow.SessionBasedFlowRequestService.resultById", clock, maxClientDelay);
        this.flowStateByIdStore = new SessionStore("com.atlassian.oauth2.client.lib.flow.SessionBasedFlowRequestService.flowState", clock, maxOauthFlowDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public FlowRequest createFlowRequest(@Nonnull HttpSession session, @Nonnull ClientConfiguration clientConfiguration, @Nonnull Function<String, String> clientCallbackUrlProvider) {
        this.httpsValidator.assertSecure(clientConfiguration);
        String flowRequestId = this.idGenerator.generate();
        FlowRequestData data = new FlowRequestData(clientConfiguration, clientCallbackUrlProvider.apply(flowRequestId), flowRequestId, null);
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            this.transition(session, flowRequestId, Objects::isNull, FlowState.CREATED_BY_CLIENT);
            this.requestByIdStore.store(session, flowRequestId, data);
            this.eventPublisher.publish((Object)new FlowRequestStartedEvent(flowRequestId));
            return new FlowRequestImpl(flowRequestId, this.redirectUrlResolver.getInitFlowUrl(flowRequestId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public FlowResult getFlowResult(@Nonnull HttpSession session, @Nonnull String flowRequestId) {
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            this.transition(session, flowRequestId, FlowState.HAS_RESULT::equals, null);
            return this.resultByIdStore.remove(session, flowRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public FlowRequestData fetchFlowRequestDataById(@Nonnull HttpSession session, @Nonnull String flowRequestId) {
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            this.transition(session, flowRequestId, FlowState.CREATED_BY_CLIENT::equals, FlowState.FETCHED_BY_ID);
            FlowRequestData data = this.requestByIdStore.remove(session, flowRequestId);
            FlowRequestData dataWithState = new FlowRequestData(data.getClientConfiguration(), data.getClientCallbackUrl(), data.getFlowRequestId(), this.stateGenerator.generate());
            this.requestByStateStore.store(session, dataWithState.getState(), dataWithState);
            return dataWithState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public FlowRequestData fetchFlowRequestDataByState(@Nonnull HttpSession session, @Nonnull String state) {
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            FlowRequestData data = this.requestByStateStore.remove(session, state);
            this.transition(session, data.getFlowRequestId(), FlowState.FETCHED_BY_ID::equals, FlowState.FETCHED_BY_STATE);
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFlowRequest(@Nonnull HttpSession session, @Nonnull String flowRequestId, @Nonnull ClientToken clientToken) throws IllegalArgumentException {
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            this.transition(session, flowRequestId, FlowState.FETCHED_BY_STATE::equals, FlowState.HAS_RESULT);
            this.resultByIdStore.store(session, flowRequestId, new FlowResultImpl(clientToken));
        }
        this.eventPublisher.publish((Object)new FlowRequestCompletedEvent(flowRequestId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFlowRequest(@Nonnull HttpSession session, @Nonnull String flowRequestId, @Nonnull FlowRequestError error) throws IllegalArgumentException {
        Object object = this.monitors.getMonitor(session);
        synchronized (object) {
            this.transition(session, flowRequestId, state -> state == FlowState.FETCHED_BY_ID || state == FlowState.FETCHED_BY_STATE, FlowState.HAS_RESULT);
            this.resultByIdStore.store(session, flowRequestId, new FlowResultImpl(error));
        }
        this.eventPublisher.publish((Object)new FlowRequestCompletedEvent(flowRequestId));
    }

    private void transition(HttpSession session, String flowRequestId, Predicate<FlowState> expectedState, FlowState newState) {
        try {
            if (newState == null) {
                logger.debug("Getting flow result from a session with an id [{}] and request id [{}]", (Object)session.getId(), (Object)flowRequestId);
            } else {
                logger.debug("Making transition for an entry to new state [{}] from a session with an id [{}] and request id [{}]", new Object[]{newState.name(), session.getId(), flowRequestId});
            }
            this.flowStateByIdStore.store(session, flowRequestId, expectedState, newState);
        }
        catch (RuntimeException e) {
            this.cleanup(session, flowRequestId);
            throw e;
        }
    }

    private void cleanup(HttpSession session, String flowRequestId) {
        this.requestByIdStore.removeIfPresent(session, flowRequestId);
        this.resultByIdStore.removeIfPresent(session, flowRequestId);
        this.flowStateByIdStore.removeIfPresent(session, flowRequestId);
    }

    static enum FlowState {
        CREATED_BY_CLIENT,
        FETCHED_BY_ID,
        FETCHED_BY_STATE,
        HAS_RESULT;

    }
}

