package com.atlassian.oauth2.client.api.storage.token.exception;

import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;

import javax.annotation.Nonnull;

/**
 * Indicates that a {@link ClientTokenEntity} can't be found in the database.
 */
public class TokenNotFoundException extends UnrecoverableTokenException {
    public TokenNotFoundException(@Nonnull final String message) {
        super(message);
    }

    public TokenNotFoundException(@Nonnull final String message, @Nonnull final Throwable cause) {
        super(message, cause);
    }
}
