package com.atlassian.oauth2.client.api.storage.config;

import java.util.Arrays;
import java.util.Optional;

public enum ProviderType {

    GOOGLE("google"),
    MICROSOFT("microsoft"),
    GENERIC("generic");

    public final String key;

    ProviderType(final String key) {
        this.key = key;
    }

    public static Optional<ProviderType> get(final String key) {
        return Arrays.stream(values())
                .filter(type -> type.key.equalsIgnoreCase(key))
                .findAny();
    }

    public static ProviderType getOrThrow(final String key) {
        return get(key).orElseThrow(() -> new IllegalArgumentException("Cannot find a provider type with key: " + key));
    }

    public String getKey() {
        return key;
    }
}
