package com.atlassian.oauth2.client.api.storage.token.exception;

import com.atlassian.oauth2.client.api.ClientToken;

import java.time.Instant;

/**
 * Indicates potentially recoverable problem with a {@link ClientToken}.
 */
public class RecoverableTokenException extends Exception {
    private final Instant invalidSince;

    public RecoverableTokenException(final String message, final Instant invalidSince) {
        super(message);
        this.invalidSince = invalidSince;
    }

    public RecoverableTokenException(String message, Throwable cause, final Instant invalidSince) {
        super(message, cause);
        this.invalidSince = invalidSince;
    }

    /**
     * @return since when the token was constantly invalid
     */
    public Instant getInvalidSince() {
        return invalidSince;
    }
}
