package com.atlassian.oauth2.client.api.lib.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.flow.request.completed")
public class FlowRequestCompletedEvent {

    private final String flowRequestId;
    private final String clientId;
    private final String providerType;

    /**
     * @deprecated use {@link #FlowRequestCompletedEvent(String, String, String)}} instead
     */
    @Deprecated
    public FlowRequestCompletedEvent(final String flowRequestId) {
        this.flowRequestId = flowRequestId;
        this.clientId = null;
        this.providerType = null;
    }

    public FlowRequestCompletedEvent(final String flowRequestId,
                                     final String clientId,
                                     final String providerType) {
        this.flowRequestId = flowRequestId;
        this.clientId = clientId;
        this.providerType = providerType;
    }

    public String getFlowRequestId() {
        return this.flowRequestId;
    }

    public String getClientId() {
        return clientId;
    }

    public String getProviderType() {
        return providerType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final FlowRequestCompletedEvent that = (FlowRequestCompletedEvent) o;
        return Objects.equals(flowRequestId, that.flowRequestId) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(providerType, that.providerType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowRequestId, clientId, providerType);
    }
}
