package com.atlassian.oauth2.client.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.Instant;

/**
 * Provides additional information about a {@link ClientToken}.
 */
public interface ClientTokenMetadata {
    /**
     * Information about the state of the token, based on its last usage.
     */
    enum ClientTokenStatus {
        /**
         * Indicates that this token hasn't been used yet.
         */
        UNKNOWN,
        /**
         * Indicates that this token pair has been successfully used during last authorisation attempt.
         */
        VALID,
        /**
         * Indicates there was an error which occurred during last authorisation attempt.
         * The {@link ClientToken#getRefreshToken() refresh token} may be used to try to fix this problem.
         * Without successful authorisation attempt it will eventually transition into {@link #UNRECOVERABLE}.
         */
        RECOVERABLE,
        /**
         * Indicates that the token is permanently unrecoverable and new {@link ClientToken} must be obtained.
         * The {@link ClientToken#getRefreshToken() refresh token} can't be used to fix this problem.
         */
        UNRECOVERABLE
    }

    /**
     * Tells whether the token is known to be valid or invalid, based on its last usage.
     */
    @Nonnull
    ClientTokenStatus getStatus();

    /**
     * When status of this token was last updated
     */
    @Nonnull
    Instant getLastStatusUpdated();

    /**
     * When was this token last refreshed.
     */
    @Nullable
    Instant getLastRefreshed();

    /**
     * How many times has this particular token been refreshed.
     */
    int getRefreshCount();
}
