package com.atlassian.oauth2.client.api.storage.token.exception;

import com.atlassian.oauth2.client.api.ClientToken;

import javax.annotation.Nonnull;

/**
 * Indicates that the {@link ClientToken#getRefreshToken() refresh token} of a {@link ClientToken} has expired, and it's
 * no longer possible to automatically obtain a new {@link ClientToken#getAccessToken() access token}.
 */
public class RefreshTokenExpiredException extends UnrecoverableTokenException {
    public RefreshTokenExpiredException(@Nonnull final String message) {
        super(message);
    }

    public RefreshTokenExpiredException(@Nonnull final String message, @Nonnull final Throwable cause) {
        super(message, cause);
    }
}
