package com.atlassian.oauth2.client.api.storage.token;

import com.atlassian.oauth2.client.api.storage.token.exception.TokenNotFoundException;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public interface ClientTokenStorageService {

    /**
     * Creates or updates the {@link ClientTokenEntity}
     *
     * @param clientTokenEntity the entity to create
     * @return The saved entity, with the ID if created
     * @throws TokenNotFoundException if the token for the given id wasn't found
     */
    @Nonnull
    ClientTokenEntity save(@Nonnull ClientTokenEntity clientTokenEntity) throws TokenNotFoundException;

    /**
     * @param id of the {@link ClientTokenEntity} to delete
     * @throws TokenNotFoundException if the token for the given id wasn't found
     */
    void delete(@Nonnull String id) throws TokenNotFoundException;

    /**
     * @param id of the {@link ClientTokenEntity} from the store
     * @return The {@link ClientTokenEntity} from the store for the id, or {@link Optional#empty}
     */
    @Nonnull
    Optional<ClientTokenEntity> getById(@Nonnull String id);

    /**
     * @param id of the {@link ClientTokenEntity} from the store
     * @return The {@link ClientTokenEntity} from the store for the id
     * @throws TokenNotFoundException if the token for the given id wasn't found
     */
    @Nonnull
    ClientTokenEntity getByIdOrFail(@Nonnull final String id) throws TokenNotFoundException;

    /**
     * @return All the saved {@link ClientTokenEntity} access tokens expiring before the timestamp, or an empty list
     */
    @Nonnull
    List<ClientTokenEntity> getAccessTokensExpiringBefore(@Nonnull Instant timestamp);

    /**
     * @return All the saved {@link ClientTokenEntity} refresh tokens expiring before the timestamp, or an empty list
     */
    @Nonnull
    List<ClientTokenEntity> getRefreshTokensExpiringBefore(@Nonnull Instant timestamp);
}
