package com.atlassian.oauth2.client.api.storage.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.token.created")
public class ClientTokenCreatedEvent implements ClientTokenEvent {

    private final String clientTokenId;

    public ClientTokenCreatedEvent(final String clientTokenId) {
        this.clientTokenId = clientTokenId;
    }

    @Override
    public String getClientTokenId() {
        return clientTokenId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientTokenCreatedEvent that = (ClientTokenCreatedEvent) o;
        return Objects.equals(clientTokenId, that.clientTokenId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientTokenId);
    }
}
