package com.atlassian.oauth2.client.api.storage.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.configuration.updated")
public class ClientConfigurationUpdatedEvent {

    private final String clientConfigurationId;

    public ClientConfigurationUpdatedEvent(final String clientConfigurationId) {
        this.clientConfigurationId = clientConfigurationId;
    }

    public String getClientConfigurationId() {
        return clientConfigurationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final ClientConfigurationUpdatedEvent that = (ClientConfigurationUpdatedEvent) o;
        return Objects.equals(clientConfigurationId, that.clientConfigurationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientConfigurationId);
    }
}
