package com.atlassian.oauth2.client.api.lib.event;

import com.atlassian.analytics.api.annotations.EventName;

import java.util.Objects;

@EventName("plugins.oauth2.client.flow.request.started")
public class FlowRequestStartedEvent {

    private final String flowRequestId;

    public FlowRequestStartedEvent(final String flowRequestId) {
        this.flowRequestId = flowRequestId;
    }

    public String getFlowRequestId() {
        return this.flowRequestId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final FlowRequestStartedEvent that = (FlowRequestStartedEvent) o;
        return Objects.equals(flowRequestId, that.flowRequestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowRequestId);
    }
}
