package com.atlassian.oauth2.client.api;

import com.atlassian.oauth2.client.api.storage.config.ProviderType;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Configuration for the OAuth 2 flow providing details on the
 * provider and required values in order to complete the flow.
 */
public interface ClientConfiguration {
    @Nonnull
    ProviderType getProviderType();

    @Nonnull
    String getClientId();

    @Nonnull
    String getClientSecret();

    @Nonnull
    String getAuthorizationEndpoint();

    @Nonnull
    String getTokenEndpoint();

    @Nonnull
    List<String> getScopes();
}
