/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.accesstoken;

import com.atlassian.oauth2.accesstoken.JWTClaimSetBuilder;
import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.nimbusds.jwt.JWTClaimsSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.ValidationException;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class SessionClaimSet {
    public static final String SCOPES_CLAIM_NAME = "scp";
    public static final String ACTOR_CLAIM_NAME = "act";
    public static final String TYPE_CLAIM_NAME = "typ";
    public static final String TYPE_CLAIM_VALUE = "atlassian-coat";
    public static final String VERSION_CLAIM_NAME = "urn:atlassian:coat:version";
    public static final Version VERSION_CLAIM_CURRENT_VALUE = Version.valueOf((String)"1.0.0");
    private final JWTClaimsSet claimSet;

    public SessionClaimSet(@Nonnull String authorizationServerId, @Nonnull String impersonatedUserId, @Nonnull String oauthClientId, @Nonnull URL resourceServerUrl, @Nonnull Set<String> scopes, @Nonnull Duration sessionDuration) {
        DateTime now = DateTime.now();
        String jti = UUID.randomUUID().toString();
        this.claimSet = new JWTClaimSetBuilder().issuer(authorizationServerId).subject(impersonatedUserId).audience(resourceServerUrl.toExternalForm()).issueTime(now.toDate()).expirationTime(now.plus((ReadableDuration)sessionDuration).toDate()).jwtID(jti).claim(SCOPES_CLAIM_NAME, scopes).claim(ACTOR_CLAIM_NAME, ImmutableMap.of((Object)"sub", (Object)oauthClientId)).claim(TYPE_CLAIM_NAME, TYPE_CLAIM_VALUE).claim(VERSION_CLAIM_NAME, VERSION_CLAIM_CURRENT_VALUE.toString()).build();
    }

    public SessionClaimSet(@Nonnull String authorizationServerId, @Nonnull String impersonatedUserId, @Nonnull String oauthClientId, @Nonnull URL resourceServerUrl, @Nonnull Set<String> scopes) {
        this(authorizationServerId, impersonatedUserId, oauthClientId, resourceServerUrl, scopes, Duration.standardMinutes((long)15L));
    }

    private SessionClaimSet(@Nonnull JWTClaimsSet claimSet) {
        this.claimSet = claimSet;
    }

    public static Optional<SessionClaimSet> from(JWTClaimsSet jwtClaimsSet) {
        SessionClaimSet claimSet = new SessionClaimSet(jwtClaimsSet);
        return claimSet.getType().flatMap(type -> {
            if (type.equals(TYPE_CLAIM_VALUE)) {
                return Optional.of(claimSet);
            }
            return Optional.empty();
        });
    }

    public static Optional<SessionClaimSet> parse(@Nonnull String claimSetJsonString) throws java.text.ParseException {
        return SessionClaimSet.from(JWTClaimsSet.parse((String)claimSetJsonString));
    }

    public JWTClaimsSet jwtClaimSet() {
        return this.claimSet;
    }

    public String getAuthorizationServerId() {
        return this.claimSet.getIssuer();
    }

    public String getImpersonatedUserId() {
        return this.claimSet.getSubject();
    }

    public Set<String> getScopes() {
        try {
            List scopes = this.claimSet.getStringListClaim(SCOPES_CLAIM_NAME);
            if (scopes == null) {
                return Collections.emptySet();
            }
            return scopes.stream().collect(Collectors.toSet());
        }
        catch (java.text.ParseException e) {
            throw new ValidationException(String.format("Invalid value for scopes: %s - %s", this.claimSet.getClaim(SCOPES_CLAIM_NAME), e.getMessage()));
        }
    }

    public Date getIssueTime() {
        return this.claimSet.getIssueTime();
    }

    public Date getExpirationTime() {
        return this.claimSet.getExpirationTime();
    }

    public String getOauthClientId() {
        return (String)this.actor().get("sub");
    }

    public String getJWTID() {
        return this.claimSet.getJWTID();
    }

    public List<URL> getResourceServerUrls() {
        List audience = this.claimSet.getAudience();
        if (audience == null) {
            return ImmutableList.of();
        }
        return audience.stream().map(urlString -> {
            try {
                return new URL((String)urlString);
            }
            catch (MalformedURLException e) {
                throw new ValidationException("The audience does not contain valid resource server urls");
            }
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    Optional<String> getType() {
        return Optional.ofNullable(this.getTyp());
    }

    String getTyp() {
        try {
            return this.claimSet.getStringClaim(TYPE_CLAIM_NAME);
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    public Version getCoatVersion() {
        try {
            String versionString = this.claimSet.getStringClaim(VERSION_CLAIM_NAME);
            return versionString != null ? Version.valueOf((String)versionString) : null;
        }
        catch (ParseException | java.text.ParseException e) {
            throw new ValidationException("Invalid version claim. Must be a string value representing a valid semantic version. Parsing to string failed: " + e.getMessage());
        }
    }

    public String toString() {
        return this.claimSet.toJSONObject().toString();
    }

    private Map<String, Object> actor() {
        Object obj = this.claimSet.getClaim(ACTOR_CLAIM_NAME);
        if (obj == null) {
            return Collections.emptyMap();
        }
        if (!(obj instanceof Map)) {
            throw new ValidationException("Invalid act claim type. Must be a Map. Found (" + obj.getClass().getSimpleName() + ")");
        }
        return (Map)obj;
    }
}

