/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.sal;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractSettingsProperties {
    private final Map<String, String> properties;

    public AbstractSettingsProperties() {
        this.properties = Maps.newHashMap();
    }

    public AbstractSettingsProperties(Properties properties) {
        this.properties = Maps.fromProperties((Properties)properties);
    }

    public final Properties asProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            if (prop.getValue() == null) continue;
            props.put(prop.getKey(), prop.getValue());
        }
        return props;
    }

    protected final void put(String key, String value) {
        this.properties.put(key, value);
    }

    protected final String get(String key) {
        return this.properties.get(key);
    }
}

