/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.sal;

import com.atlassian.oauth.Token;
import com.atlassian.oauth.shared.sal.AbstractSettingsProperties;
import com.atlassian.oauth.shared.sal.PropertiesHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;

public abstract class TokenProperties
extends AbstractSettingsProperties {
    static final String TOKEN = "token";
    static final String TOKEN_SECRET = "tokenSecret";
    static final String TYPE = "type";
    static final String CONSUMER_KEY = "consumerKey";
    static final String PROPERTIES = "properties";

    public TokenProperties(Token token) {
        this.putToken(token.getToken());
        this.putTokenSecret(token.getTokenSecret());
        this.putTokenType(token.isAccessToken() ? TokenType.ACCESS : TokenType.REQUEST);
        this.putConsumerKey(token.getConsumer().getKey());
        if (!token.getProperties().isEmpty()) {
            this.putProperties(token.getProperties());
        }
    }

    public TokenProperties(Properties properties) {
        super(properties);
    }

    public String getToken() {
        return this.get(TOKEN);
    }

    public String getTokenSecret() {
        return this.get(TOKEN_SECRET);
    }

    public boolean isAccessToken() {
        return TokenType.ACCESS == this.getTokenType();
    }

    private TokenType getTokenType() {
        return TokenType.valueOf(this.get(TYPE));
    }

    public String getConsumerKey() {
        return this.get(CONSUMER_KEY);
    }

    public Map<String, String> getProperties() {
        String propStr = this.get(PROPERTIES);
        if (propStr == null) {
            return ImmutableMap.of();
        }
        return Maps.fromProperties((Properties)PropertiesHelper.fromString(propStr));
    }

    private void putToken(String token) {
        this.put(TOKEN, token);
    }

    private void putTokenSecret(String tokenSecret) {
        this.put(TOKEN_SECRET, tokenSecret);
    }

    private void putTokenType(TokenType type) {
        this.put(TYPE, type != null ? type.name() : null);
    }

    private void putConsumerKey(String consumerKey) {
        this.put(CONSUMER_KEY, consumerKey);
    }

    private void putProperties(Map<String, String> properties) {
        this.put(PROPERTIES, PropertiesHelper.toString(PropertiesHelper.asProperties(properties)));
    }

    private static enum TokenType {
        ACCESS,
        REQUEST;

    }
}

