/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.shared.sal;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashingLongPropertyKeysPluginSettings
implements PluginSettings {
    private final PluginSettings pluginSettings;
    private static final int MAX_KEY_LENGTH = 100;
    private static final Logger LOG = LoggerFactory.getLogger(HashingLongPropertyKeysPluginSettings.class);

    public HashingLongPropertyKeysPluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public Object get(String key) {
        return this.pluginSettings.get(this.hashKeyIfTooLong(key));
    }

    private String hashKeyIfTooLong(String key) {
        if (key.length() > 100) {
            String keyHash = DigestUtils.md5Hex((String)key);
            String keptOriginalKey = key.substring(0, 100 - keyHash.length());
            LOG.debug("Key '" + key + "' exceeds " + 100 + " characters. Key length is: '" + key.length() + "'. Hashed key value is: '" + keyHash + "'. Using combined original key and hash value '" + keptOriginalKey + keyHash + " as the key.");
            String hashedKey = keptOriginalKey + keyHash;
            this.migrateKey(key, hashedKey);
            return hashedKey;
        }
        return key;
    }

    private void migrateKey(String oldkey, String newKey) {
        if (oldkey.equals(newKey)) {
            return;
        }
        try {
            Object o = this.pluginSettings.get(oldkey);
            if (o != null) {
                this.pluginSettings.put(newKey, o);
                this.pluginSettings.remove(oldkey);
            }
        }
        catch (Exception ex) {
            LOG.debug("Exception thrown when attempting to migrate key '" + oldkey + "' to new key '" + newKey + "', application did never support keys > " + 100, (Throwable)ex);
        }
    }

    public Object put(String key, Object value) {
        return this.pluginSettings.put(this.hashKeyIfTooLong(key), value);
    }

    public Object remove(String key) {
        return this.pluginSettings.remove(this.hashKeyIfTooLong(key));
    }
}

