/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.internal.servlet;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerCreationException;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.security.Key;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConsumerInfoServlet
extends HttpServlet {
    private final ConsumerService store;
    private final TemplateRenderer renderer;

    public ConsumerInfoServlet(ConsumerService store, TemplateRenderer renderer) {
        this.store = (ConsumerService)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/xml;charset=UTF-8");
        Consumer consumer = this.store.getConsumer();
        ImmutableMap context = ImmutableMap.of((Object)"consumer", (Object)consumer, (Object)"encodedPublicKey", (Object)RSAKeys.toPemEncoding((Key)consumer.getPublicKey()));
        try {
            this.renderer.render("view.xml.vm", (Map)context, (Writer)response.getWriter());
        }
        catch (RenderingException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ConsumerCreationException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

