package com.atlassian.oauth.util;

import org.apache.commons.lang3.Validate;

import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * Utility to perform checks on parameters.
 */
public final class Check {
    /**
     * @deprecated use {@link Objects#requireNonNull}
     */
    @Deprecated
    public static <T> T notNull(T reference, Object errorMessage) {
        return requireNonNull(reference, String.valueOf(errorMessage));
    }

    /**
     * Checks if the string is {@code null}, empty, or contains only whitespace.
     *
     * @param str          {@code String} to check
     * @param errorMessage to be used as a message in case there's an exception thrown
     * @return {@code str} so it may be used
     * @throws NullPointerException     if {@code str} is {@code null}
     * @throws IllegalArgumentException if {@code str} is empty or contains only whitespace
     */
    public static String notBlank(String str, Object errorMessage) {
        Validate.notBlank(str, String.valueOf(errorMessage));
        return str;
    }
}
