package com.atlassian.oauth.event;

import javax.annotation.ParametersAreNullableByDefault;

/**
 * This event is published when an access token is removed from the service provider.
 */
@ParametersAreNullableByDefault
public class AccessTokenRemovedEvent extends TokenRemovedEvent {
    /**
     * This is for backwards compatibility.
     *
     * @deprecated use {@link #AccessTokenRemovedEvent(String, String)} instead
     */
    @Deprecated
    public AccessTokenRemovedEvent(String username) {
        this(username, null);
    }

    /**
     * @param username belonging to the user who's access token is being revoked
     * @param consumerKey the consumer key with which the token was previously associated
     */
    public AccessTokenRemovedEvent(String username, String consumerKey) {
        super(username, consumerKey);
    }
}
