/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth;

import com.atlassian.oauth.util.Check;
import java.net.URI;
import java.security.PublicKey;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.builder.ToStringBuilder;

@Immutable
public final class Consumer {
    private final String key;
    private final String name;
    private final String description;
    private final SignatureMethod signatureMethod;
    private final PublicKey publicKey;
    private final URI callback;

    private Consumer(InstanceBuilder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.signatureMethod = builder.signatureMethod;
        this.publicKey = builder.publicKey;
        this.description = builder.description;
        this.callback = builder.callback;
    }

    public static InstanceBuilder key(String key) {
        return new InstanceBuilder(Check.notNull(key, "key"));
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getCallback() {
        return this.callback;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("name", (Object)this.name).append("description", (Object)this.description).append("callback", (Object)this.callback).append("signatureMethod", (Object)this.signatureMethod).append("publicKey", (Object)this.publicKey).toString();
    }

    public static final class InstanceBuilder {
        private final String key;
        private String name;
        private SignatureMethod signatureMethod;
        private PublicKey publicKey;
        private String description;
        private URI callback;

        public InstanceBuilder(String key) {
            this.key = key;
        }

        public InstanceBuilder name(String name) {
            this.name = Check.notNull(name);
            return this;
        }

        public InstanceBuilder signatureMethod(SignatureMethod signatureMethod) {
            this.signatureMethod = Check.notNull(signatureMethod);
            return this;
        }

        public InstanceBuilder publicKey(PublicKey publicKey) {
            this.signatureMethod = SignatureMethod.RSA_SHA1;
            this.publicKey = Check.notNull(publicKey);
            return this;
        }

        public InstanceBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InstanceBuilder callback(URI callback) {
            this.callback = callback;
            return this;
        }

        public Consumer build() {
            Check.notNull(this.name, "name");
            Check.notNull(this.signatureMethod, "signatureMethod");
            if (this.signatureMethod == SignatureMethod.RSA_SHA1) {
                Check.notNull(this.publicKey, "publicKey must be set when the signature method is RSA-SHA1");
            }
            return new Consumer(this);
        }
    }

    public static enum SignatureMethod {
        HMAC_SHA1,
        RSA_SHA1;

    }
}

