/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.serviceprovider;

import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.ServiceProviderTokenStore;
import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ListConsumersServlet
extends AbstractAdminServlet {
    private final ServiceProviderConsumerStore consumerStore;
    private final TemplateRenderer renderer;
    private final ServiceProviderTokenStore tokenStore;

    public ListConsumersServlet(ServiceProviderConsumerStore consumerStore, ServiceProviderTokenStore tokenStore, TemplateRenderer renderer, UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.consumerStore = (ServiceProviderConsumerStore)Preconditions.checkNotNull((Object)consumerStore, (Object)"consumerStore");
        this.tokenStore = (ServiceProviderTokenStore)Preconditions.checkNotNull((Object)tokenStore, (Object)"tokenStore");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    protected void doRestrictedGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        Iterable consumers = this.consumerStore.getAll();
        this.renderer.render("consumers/list.vm", (Map)ImmutableMap.of((Object)"consumers", (Object)consumers), (Writer)response.getWriter());
    }

    protected void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String consumerKey = request.getParameter("key");
        if (consumerKey == null) {
            response.sendError(400);
            return;
        }
        this.tokenStore.removeByConsumer(consumerKey);
        this.consumerStore.remove(consumerKey);
    }
}

