/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.serviceprovider;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.admin.serviceprovider.AbstractConsumerServlet;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditConsumerServlet
extends AbstractConsumerServlet {
    private static final String EDIT_TEMPLATE = "consumers/edit.vm";
    private static final String ERROR_TEMPLATE = "consumers/edit-error.vm";
    private final ServiceProviderConsumerStore store;
    private final TemplateRenderer renderer;

    public EditConsumerServlet(ServiceProviderConsumerStore store, TemplateRenderer renderer, UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.store = (ServiceProviderConsumerStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    public void doRestrictedGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String key = request.getParameter("key");
        if (key == null) {
            response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/consumers/list");
            return;
        }
        Consumer consumer = this.store.get(key);
        if (consumer == null) {
            response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/consumers/list");
            return;
        }
        response.setContentType("text/html;charset=UTF-8");
        this.renderer.render(EDIT_TEMPLATE, (Map)ImmutableMap.of((Object)"key", (Object)key, (Object)"name", (Object)consumer.getName(), (Object)"description", (Object)consumer.getDescription(), (Object)"publicKey", (Object)RSAKeys.toPemEncoding((Key)consumer.getPublicKey()), (Object)"callback", (Object)(consumer.getCallback() != null ? consumer.getCallback().toASCIIString() : "")), (Writer)response.getWriter());
    }

    public void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String key = request.getParameter("key");
        if (key == null) {
            response.setStatus(400);
            this.renderer.render(ERROR_TEMPLATE, (Map)ImmutableMap.of((Object)"message", (Object)"com.atlassian.oauth.serviceprovider.missing.consumer.key"), (Writer)response.getWriter());
            return;
        }
        if (this.store.get(key) == null) {
            response.setStatus(400);
            this.renderer.render(ERROR_TEMPLATE, (Map)ImmutableMap.of((Object)"message", (Object)"com.atlassian.oauth.serviceprovider.unknown.consumer.key"), (Writer)response.getWriter());
            return;
        }
        HashMap fieldErrorMessages = Maps.newHashMap();
        String name = this.checkRequiredParameter(request, "name", fieldErrorMessages, "missing.consumer.name");
        String description = request.getParameter("description");
        URI callback = this.getCallbackUri(request, fieldErrorMessages);
        PublicKey publicKey = this.getPublicKey(request, fieldErrorMessages);
        if (!fieldErrorMessages.isEmpty()) {
            response.setContentType("text/html;charset=UTF-8");
            this.renderer.render(EDIT_TEMPLATE, this.buildErrorMap(request, "fieldErrorMessages", fieldErrorMessages), (Writer)response.getWriter());
            return;
        }
        Consumer newConsumer = Consumer.key((String)key).name(name).description(description).callback(callback).publicKey(publicKey).build();
        try {
            this.store.put(newConsumer);
        }
        catch (StoreException e) {
            response.setContentType("text/html;charset=UTF-8");
            this.renderer.render(EDIT_TEMPLATE, this.buildErrorMap(request, "errorMessages", e.getMessage()), (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/consumers/list");
    }
}

