/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.serviceprovider;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.admin.serviceprovider.AbstractConsumerServlet;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import com.atlassian.oauth.shared.servlet.Message;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AddConsumerManuallyServlet
extends AbstractConsumerServlet {
    private static final String ADD_TEMPLATE = "consumers/add.vm";
    private final ServiceProviderConsumerStore store;
    private final TemplateRenderer renderer;

    public AddConsumerManuallyServlet(ServiceProviderConsumerStore store, TemplateRenderer renderer, MessageFactory messageFactory, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.store = (ServiceProviderConsumerStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    protected void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, Message> fieldErrorMessages = new HashMap<String, Message>();
        String key = this.checkRequiredParameter(request, "key", fieldErrorMessages, "com.atlassian.oauth.serviceprovider.missing.consumer.key");
        String name = this.checkRequiredParameter(request, "name", fieldErrorMessages, "missing.consumer.name");
        String description = request.getParameter("description");
        PublicKey publicKey = this.getPublicKey(request, fieldErrorMessages);
        URI callback = this.getCallbackUri(request, fieldErrorMessages);
        if (!fieldErrorMessages.isEmpty()) {
            response.setContentType("text/html;charset=UTF-8");
            this.renderer.render(ADD_TEMPLATE, this.buildErrorMap(request, "fieldErrorMessages", fieldErrorMessages), (Writer)response.getWriter());
            return;
        }
        Consumer consumer = Consumer.key((String)key).name(name).publicKey(publicKey).description(description).callback(callback).build();
        try {
            this.store.put(consumer);
        }
        catch (StoreException e) {
            response.setContentType("text/html;charset=UTF-8");
            this.renderer.render(ADD_TEMPLATE, this.buildErrorMap(request, "errorMessages", e.getMessage()), (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/consumers/list");
    }
}

