/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.serviceprovider;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.IllegalUriException;
import com.atlassian.oauth.shared.servlet.Message;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AddConsumerByUrlServlet
extends AbstractAdminServlet {
    private static final String BASE_URL_PARAMETER = "baseUrl";
    static final String CONSUMER_INFO_PATH = "plugins/servlet/oauth/consumer-info";
    private final ServiceProviderConsumerStore store;
    private final TemplateRenderer renderer;
    private final RequestFactory<Request<?, ?>> requestFactory;

    public AddConsumerByUrlServlet(ServiceProviderConsumerStore store, TemplateRenderer renderer, MessageFactory messageFactory, UserManager userManager, RequestFactory<Request<?, ?>> requestFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.store = (ServiceProviderConsumerStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull(requestFactory, (Object)"requestFactory");
    }

    protected void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI baseUri;
        try {
            baseUri = this.getBaseUri(request);
        }
        catch (IllegalUriException e) {
            this.renderError(request, response, e.getFieldMessage());
            return;
        }
        try {
            this.store.put(this.fetchConsumerInformation(baseUri));
        }
        catch (ResponseException e) {
            this.renderError(request, response, this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.consumer.communication.error", new Serializable[]{e.getMessage()}));
            return;
        }
        catch (StoreException e) {
            this.renderError(request, response, this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.error.adding.consumer.to.store", new Serializable[]{e.getMessage()}));
            return;
        }
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/consumers/list");
    }

    private URI getBaseUri(HttpServletRequest request) {
        URI baseUri;
        try {
            String uriParam = request.getParameter(BASE_URL_PARAMETER);
            if (uriParam == null) {
                throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.consumer.base.uri.is.required", new Serializable[0]));
            }
            if (!uriParam.endsWith("/")) {
                uriParam = uriParam + "/";
            }
            baseUri = new URI(uriParam);
        }
        catch (URISyntaxException e) {
            throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.invalid.uri", new Serializable[]{e.getMessage()}));
        }
        if (!baseUri.isAbsolute()) {
            throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.consumer.base.uri.must.be.absolute", new Serializable[0]));
        }
        if (!"http".equals(baseUri.getScheme()) && !"https".equals(baseUri.getScheme())) {
            throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.consumer.base.uri.must.be.http.or.https", new Serializable[0]));
        }
        return baseUri;
    }

    private void renderError(HttpServletRequest request, HttpServletResponse response, final Message error) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        this.renderer.render("consumers/add.vm", (Map)ImmutableMap.of((Object)"fieldErrorMessages", (Object)new HashMap<String, Message>(){
            {
                this.put(AddConsumerByUrlServlet.BASE_URL_PARAMETER, error);
            }
        }, (Object)BASE_URL_PARAMETER, (Object)request.getParameter(BASE_URL_PARAMETER)), (Writer)response.getWriter());
    }

    private Consumer fetchConsumerInformation(URI baseUri) throws ResponseException {
        ConsumerInformationResponseHandler handler = new ConsumerInformationResponseHandler();
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, baseUri.resolve(CONSUMER_INFO_PATH).toASCIIString());
        request.setHeader("Accept", "application/xml");
        request.execute((ResponseHandler)handler);
        return handler.getConsumer();
    }

    private static class ConsumerInformationResponseHandler
    implements ResponseHandler {
        private Consumer consumer;

        private ConsumerInformationResponseHandler() {
        }

        public void handle(Response response) throws ResponseException {
            if (response.getStatusCode() != 200) {
                throw new ResponseException("Server responded with an error");
            }
            if (response.getHeader("Content-Type") != null && !response.getHeader("Content-Type").startsWith("application/xml")) {
                throw new ResponseException("Server sent an invalid response");
            }
            try {
                DocumentBuilder docBuilder = this.createSafeDocumentBuilder();
                Document doc = docBuilder.parse(response.getResponseBodyAsStream());
                String consumerKey = doc.getElementsByTagName("key").item(0).getTextContent();
                String name = doc.getElementsByTagName("name").item(0).getTextContent();
                PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)doc.getElementsByTagName("publicKey").item(0).getTextContent());
                String description = null;
                if (doc.getElementsByTagName("description").getLength() > 0) {
                    description = doc.getElementsByTagName("description").item(0).getTextContent();
                }
                URI callback = null;
                if (doc.getElementsByTagName("callback").getLength() > 0) {
                    callback = new URI(doc.getElementsByTagName("callback").item(0).getTextContent());
                }
                this.consumer = Consumer.key((String)consumerKey).name(name).publicKey(publicKey).description(description).callback(callback).build();
            }
            catch (ParserConfigurationException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (SAXException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (IOException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (DOMException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new ResponseException("Unable to parse consumer information, callback is not a valid URL", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ResponseException("Unable to parse consumer information, no RSA providers are installed", (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new ResponseException("Unable to parse consumer information, the public key is not a validly encoded RSA public key", (Throwable)e);
            }
        }

        private DocumentBuilder createSafeDocumentBuilder() throws ParserConfigurationException {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return documentBuilderFactory.newDocumentBuilder();
        }

        public Consumer getConsumer() {
            return this.consumer;
        }
    }
}

