/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.serviceprovider;

import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.Message;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class AbstractConsumerServlet
extends AbstractAdminServlet {
    protected static final String CONSUMER_KEY = "key";
    protected static final String NAME = "name";
    protected static final String DESCRIPTION = "description";
    protected static final String PUBLIC_KEY = "publicKey";
    protected static final String CALLBACK = "callback";

    public AbstractConsumerServlet(UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
    }

    protected final URI getCallbackUri(HttpServletRequest request, Map<String, Message> fieldErrorMessages) {
        URI callback;
        String uriParam = request.getParameter(CALLBACK);
        if (uriParam == null || StringUtils.isEmpty((String)uriParam)) {
            return null;
        }
        try {
            if (!uriParam.endsWith("/")) {
                uriParam = uriParam + "/";
            }
            callback = new URI(uriParam);
        }
        catch (URISyntaxException e) {
            fieldErrorMessages.put(CALLBACK, this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.invalid.uri", new Serializable[0]));
            return null;
        }
        if (!callback.isAbsolute()) {
            fieldErrorMessages.put(CALLBACK, this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.callback.uri.must.be.absolute", new Serializable[0]));
            return null;
        }
        if (!"http".equals(callback.getScheme()) && !"https".equals(callback.getScheme())) {
            fieldErrorMessages.put(CALLBACK, this.messageFactory.newMessage("com.atlassian.oauth.serviceprovider.callback.uri.must.be.http.or.https", new Serializable[0]));
            return null;
        }
        return callback;
    }

    protected final PublicKey getPublicKey(HttpServletRequest request, Map<String, Message> fieldErrorMessages) {
        String publicKeyParam = this.checkRequiredParameter(request, PUBLIC_KEY, fieldErrorMessages, "missing.public.key");
        if (publicKeyParam == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            publicKey = publicKeyParam.startsWith("-----BEGIN CERTIFICATE-----") ? RSAKeys.fromEncodedCertificateToPublicKey((String)publicKeyParam) : RSAKeys.fromPemEncodingToPublicKey((String)publicKeyParam);
        }
        catch (GeneralSecurityException e) {
            fieldErrorMessages.put(PUBLIC_KEY, this.messageFactory.newMessage("invalid.public.key", new Serializable[]{e.getMessage()}));
        }
        return publicKey;
    }

    protected final Map<String, Object> buildErrorMap(HttpServletRequest req, String messageKey, String message) {
        return this.builderFromRequest(req).put((Object)messageKey, (Object)message).build();
    }

    protected final Map<String, Object> buildErrorMap(HttpServletRequest req, String messagesKey, Map<String, Message> errorMessages) {
        return this.builderFromRequest(req).put((Object)messagesKey, errorMessages).build();
    }

    private final ImmutableMap.Builder<String, Object> builderFromRequest(HttpServletRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, request, CONSUMER_KEY);
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, request, PUBLIC_KEY);
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, request, NAME);
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, request, DESCRIPTION);
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, request, CALLBACK);
        return builder;
    }

    private void putIfNotNull(ImmutableMap.Builder<String, Object> builder, HttpServletRequest request, String parameterName) {
        if (request.getParameter(parameterName) != null) {
            builder.put((Object)parameterName, (Object)request.getParameter(parameterName));
        }
    }
}

