/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.consumer;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.IllegalUriException;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.oauth.shared.servlet.RendererContextBuilder;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public final class UpdateConsumerInfoServlet
extends AbstractAdminServlet {
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String CALLBACK_PARAMETER = "callback";
    private static final String NAME_PARAMETER = "name";
    private final ConsumerService consumerService;
    private final TemplateRenderer renderer;

    public UpdateConsumerInfoServlet(ConsumerService consumerService, TemplateRenderer renderer, UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.consumerService = (ConsumerService)Preconditions.checkNotNull((Object)consumerService, (Object)"consumerService");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    public void doRestrictedGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;utf-8");
        Consumer consumer = this.consumerService.getConsumer();
        RendererContextBuilder builder = new RendererContextBuilder().put(NAME_PARAMETER, (Object)consumer.getName()).put(DESCRIPTION_PARAMETER, (Object)consumer.getDescription());
        if (consumer.getCallback() != null) {
            builder.put(CALLBACK_PARAMETER, (Object)consumer.getCallback().toASCIIString());
        }
        this.renderer.render("consumer-info/update.vm", builder.build(), (Writer)response.getWriter());
    }

    public void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HashMap fieldErrorMessages = Maps.newHashMap();
        String name = this.checkRequiredParameter(request, NAME_PARAMETER, fieldErrorMessages, "com.atlassian.oauth.consumer.consumer.name.is.required");
        String description = request.getParameter(DESCRIPTION_PARAMETER);
        URI callback = null;
        try {
            callback = this.getCallbackUri(request);
        }
        catch (IllegalUriException e) {
            fieldErrorMessages.put(CALLBACK_PARAMETER, e.getFieldMessage());
        }
        if (!fieldErrorMessages.isEmpty()) {
            response.setContentType("text/html;utf-8");
            RendererContextBuilder builder = new RendererContextBuilder().put("fieldErrorMessages", (Object)fieldErrorMessages).put(NAME_PARAMETER, (Object)name).put(DESCRIPTION_PARAMETER, (Object)description).put(CALLBACK_PARAMETER, (Object)request.getParameter(CALLBACK_PARAMETER));
            this.renderer.render("consumer-info/update.vm", builder.build(), (Writer)response.getWriter());
            return;
        }
        this.consumerService.updateHostConsumerInformation(name, description, callback);
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/view-consumer-info");
    }

    private URI getCallbackUri(HttpServletRequest request) {
        URI callback;
        String callbackParam = request.getParameter(CALLBACK_PARAMETER);
        if (callbackParam == null || StringUtils.isEmpty((String)callbackParam)) {
            return null;
        }
        try {
            callback = new URI(callbackParam);
        }
        catch (URISyntaxException e) {
            throw new IllegalUriException(this.messageFactory.newMessage("invalid.url", new Serializable[]{e.getMessage()}));
        }
        if (!callback.isAbsolute()) {
            throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.consumer.consumer.callback.must.be.absolute", new Serializable[0]));
        }
        if (!"http".equals(callback.getScheme()) && !"https".equals(callback.getScheme())) {
            throw new IllegalUriException(this.messageFactory.newMessage("com.atlassian.oauth.consumer.consumer.callback.must.be.http.or.https", new Serializable[0]));
        }
        return callback;
    }
}

