/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.admin.consumer;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.shared.servlet.AbstractAdminServlet;
import com.atlassian.oauth.shared.servlet.MessageFactory;
import com.atlassian.oauth.shared.servlet.RendererContextBuilder;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AddServiceProviderServlet
extends AbstractAdminServlet {
    private static final String CONSUMER_KEY_PARAMETER = "consumerKey";
    private static final String NAME_PARAMETER = "name";
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String SHARED_SECRET_PARAMETER = "sharedSecret";
    private final TemplateRenderer renderer;
    private final ConsumerService service;

    public AddServiceProviderServlet(ConsumerService service, TemplateRenderer renderer, UserManager userManager, MessageFactory messageFactory, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        super(userManager, messageFactory, loginUriProvider, webSudoManager);
        this.service = (ConsumerService)Preconditions.checkNotNull((Object)service, (Object)"consumerService");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
    }

    public void doRestrictedGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=UTF-8");
        this.renderer.render("service-providers/add.vm", (Writer)response.getWriter());
    }

    public void doRestrictedPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HashMap fieldErrorMessages = Maps.newHashMap();
        String consumerKey = this.checkRequiredParameter(request, CONSUMER_KEY_PARAMETER, fieldErrorMessages, "com.atlassian.oauth.consumer.serviceprovider.key.is.required");
        String name = this.checkRequiredParameter(request, NAME_PARAMETER, fieldErrorMessages, "com.atlassian.oauth.consumer.serviceprovider.name.is.required");
        String description = request.getParameter(DESCRIPTION_PARAMETER);
        String sharedSecret = this.checkRequiredParameter(request, SHARED_SECRET_PARAMETER, fieldErrorMessages, "com.atlassian.oauth.consumer.serviceprovider.shared.secret.is.required");
        if (!fieldErrorMessages.isEmpty()) {
            response.setContentType("text/html;utf-8");
            RendererContextBuilder builder = new RendererContextBuilder().put("fieldErrorMessages", (Object)fieldErrorMessages).put(CONSUMER_KEY_PARAMETER, (Object)consumerKey).put(NAME_PARAMETER, (Object)name).put(DESCRIPTION_PARAMETER, (Object)description).put(SHARED_SECRET_PARAMETER, (Object)sharedSecret);
            this.renderer.render("service-providers/add.vm", builder.build(), (Writer)response.getWriter());
            return;
        }
        Consumer consumer = Consumer.key((String)consumerKey).name(name).signatureMethod(Consumer.SignatureMethod.HMAC_SHA1).description(description).build();
        this.service.add(name, consumer, sharedSecret);
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/oauth/service-providers/list");
    }
}

