// The main Notifications view which holds the list of notifications (notification-view.js)
MW.NotificationMainView = MW.NotificationMainAbstractView.extend({

    renderEmptyNotificationsTemplate: function(container){
        container.html(MyWork.Templates.Mobile.noNotifications());
    },

    renderTemplate: function(container) {
        container.html(MyWork.Templates.Mobile.mainNotification());
        new MW.Confluence.Mobile.HeaderView({el: container[0],
                                       title: AJS.I18n.getText('com.atlassian.mywork.header.notifications')}).render();
    },

    showCard: function(){
        $("body").removeClass("android-input-hack");
        MW.Router.navigateToMain();
        MW.CardAnimation.showCard($(".mw-notification"), MW.Slide.FROM_LEFT);
        MW.showNotificationMainCard();
    }
});

MW.NotificationView = MW.NotificationAbstractView.extend({
    renderTemplate: function(container) {
        container.addClass("mw-mobile-entry-item");
        container.html(MyWork.Templates.Mobile.notificationView({notification: this.model.toJSON()}));
    },

    renderDrilldownTemplate: function(drilldownView, instant){
        var drilldownViewHtml = drilldownView.render().el;
        if (instant) {
            drilldownViewHtml = $(drilldownViewHtml).removeClass("off-right");
        }
        $("#inner-container").append(drilldownViewHtml);
        this.globalEvents.trigger("showNotificationDrilldownCard", instant ? 0 : undefined);
    }
});

MW.NotificationEntryView = MW.NotificationEntryAbstractView.extend({
    createNotificationTitle: function(notification){
        return MW.escapeHTML(notification.get("metadata").user) || notification.get('title');
    },
    addTime: function($actions, time) {
        $actions.prepend($('<li />').text(time));
    },

    renderTemplate: function(container, templateParams){
        container.html(MyWork.Templates.Mobile.drilldownEntry(templateParams));
    }
});

MW.HeaderView = MW.HeaderAbstractView.extend({
    renderTemplate: function(container, attributes){
        container.html(MyWork.Templates.Mobile.drilldownHeader(attributes));
    },

    showTooltip: function() {
        // noop
    },

    selectTask: function() {
        // noop
    }
});

MW.DrilldownView = MW.DrilldownAbstractView.extend({
   renderTemplate: function(container){
       $("body").addClass("android-input-hack");
       container.html(MyWork.Templates.Mobile.notificationDrilldown());

       // Since we remove drilldowns, always create a new header...
       new MW.Confluence.Mobile.HeaderView({el: container[0],
                                      backText: AJS.I18n.getText('com.atlassian.mywork.header.notifications')}).render();

       // We want to initially have the notificaiton 'card' hidden from view (will be animated to slide in)
       container.addClass("nested-card").addClass("off-right");
   },

    showCardAnimation: function(slideTime){
        MW.CardAnimation.showCardInstant($(".mw-notification-drilldown"), MW.Slide.FROM_RIGHT, slideTime);
    },

    showCardAnimationReverseSlide: function(slideTime) {
        MW.CardAnimation.showCardInstant($(".mw-notification-drilldown"), MW.Slide.FROM_LEFT, slideTime);
    },

    showCollapsedGroup: function($collapsedGroup) {
        $collapsedGroup.show();
    }
});

MW.ActionView = MW.ActionAbstractView.extend({
    showForm: function($formElement) {
        $formElement.show(100);
        $formElement.find('textarea').first().each(function(i, textarea) {
            textarea.focus();
        });
    },

    getFormContainerTemplate: function(){
        return MyWork.Templates.Mobile.inlineActionForm();
    },

    getFormTextareaTemplate: function(){
        return MyWork.Templates.Mobile.inlineActionTextarea();
    },
    getFormActionButtonsTemplate: function(submitText){
        return MyWork.Templates.Mobile.inlineActionSubmit(submitText);
    }
});
