(function() {

/**
 * Joins all arguments with '.' for use as a property key.
 */
function makePropertyKey() {
    return Array.prototype.slice.apply(arguments).join('.');
}

MW.Configuration = Backbone.Model.extend({

    parse: function(data) {
        data.objectActions = {};
        data.itemActions = {};
        data.taskActions = {};
        var copy = function(to, from, action) {
            _(from).map(function(name) {
                to[name] = (to[name] || []).concat([action]);
            });
        };
        _(data.actions).each(function(action, id) {
            action.id = id;
            copy(data.objectActions, action.objectActions, action);
            copy(data.itemActions, action.actions, action);
            copy(data.taskActions, action.taskActions, action);

            // This is very dodgy, but if you have self-referencing properties jQuery blows up
            action.attrs = action.attrs || {};
            action.attrs.getAlternateAction = function() {
                return data.actions[action.attrs.alternateAction];
            };
        });
        return data;
    },

    appendUrl : function(type) {
        var path = this.getProperty(type);
        return path ? this.getUrl() + path : path;
    },

    getUrl: function() {
        return this.get('url') || '';
    },

    /**
     * Called with one or more arguments, returns the property with key equal to all of the arguments joined with
     * periods.
     */
    getProperty: function() {
        var key = makePropertyKey.apply(this, arguments);
        return this.get('properties')[key] || '';
    },

    getUserUrl: function(application, username) {
        return (this.get('url') || '') + MW.formatString(this.getProperty(application + '.user_url'), {username: encodeURIComponent(username)});
    },

    getObjectActions: function(entity, action, metadata) {
        return this.getMyActions(this.get('objectActions'), entity, action, metadata);
    },

    getActions: function(entity, action, metadata) {
        return this.getMyActions(this.get('itemActions'), entity, action, metadata);
    },

    getTaskActions: function(entity, action, metadata) {
        return this.getMyActions(this.get('taskActions'), entity, action, metadata);
    },

    getMyActions: function(map, entity, action, metadata) {
        map = map || {};
        metadata = metadata || {};
        var actions;
        if (action === "invite") {
            actions = [].concat(map[entity + '.' + action] || []);
        } else {
            actions = [].concat(map[entity] || [], map[entity + '.' + action] || []);
        }

        return _(actions).filter(_.bind(function(action) {
            return this.isMetadataMatch(metadata, action.attrs.condition || {});
        }, this));
    },

    isMetadataMatch: function(metadata, conditions) {
        return _.all(conditions, function(value, key) {
            return metadata[key] == value;
        });
    },

    i18n: function(key) {
        return this.get('i18n')[key];
    }
});
})();