MW.DeprecatedTasksView = Backbone.View.extend({

    tagName: "div",

    className: "mw-tasks card",

    events: {
        "click .mw-button-notifications" : "gotoNotifications",
        "click #mw-deprecated-task-show-me" : "closeAndShowFeatureDiscovery",
        "click #mw-deprecated-task-dissmiss" : "close"
    },

    initialize: function(options) {
        this.globalEvents = options.globalEvents;
        this.globalEvents.bind("showTaskCard", this.showTaskCard, this);
        this.userMustMigrate = (MW.$("meta[name='mw-should-migrate-tasks']").attr('content') === 'true');
    },

    render: function() {
        var $el = MW.$(this.el);
        this.renderTemplate($el);
        MW.Cookie.save(false);
        return this;
    },

    showTaskCard:function(slideTime) {
        this.completed = false;
        this.showCard(slideTime);
        this.migrateIfNeeded();
    },

    showCard:function(slideTime) {
        MW.Router.navigateToTasks();
        MW.CardAnimation.showCard(MW.$(this.el), MW.Slide.FROM_LEFT, slideTime);
    },

    renderTemplate: function(container){
        container.html(MyWork.Templates.deprecatedTasks({
            userMustMigrate: this.userMustMigrate
        }));
        container.find(".mw-button-tasks").toggleClass("on", true);
    },

    gotoNotifications: function() {
        this.globalEvents.trigger("showNotificationCard", 1);
    },

    closeAndShowFeatureDiscovery: function(e) {
        this.parentCloseAndDiscoverMyTasks();
        e.preventDefault();
    },

    close: function(e) {
        this.parentClose();
        e.preventDefault();
    },

    migrateIfNeeded: function () {
        var view = this;
        if(view.userMustMigrate) {
            $.ajax({
                'type': 'POST',
                'contentType': 'application/json',
                'data': {},
                'url': MW.contextPath + "/rest/mywork/latest/task/migrateTasks"
            }).done(function () {
                view.userMustMigrate = false;
                view.render();
            });
        } else {
            $.ajax({
                'type': 'POST',
                'contentType': 'application/json',
                'data': {},
                'url': MW.contextPath + "/rest/mywork/latest/task/hasInteracted"
            }).done(function () {
                view.userMustMigrate = false;
                view.render();
            });
        }
    },

    parentCloseAndDiscoverMyTasks: function () {
        window.parent.MW.Tasks.closeAndDiscoverMyTasks();
    },

    parentClose: function () {
        window.parent.MW.Dialog.hide();
    }
});



