/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.service;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.shareddata.SharedData;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.mywork.host.dao.RegistrationDao;
import com.atlassian.mywork.host.event.RegistrationChangedEvent;
import com.atlassian.mywork.host.service.LocalRegistrationService;
import com.atlassian.mywork.host.util.SharedDataLookup;
import com.atlassian.mywork.host.util.concurrent.LockedTaskExecutor;
import com.atlassian.mywork.model.Registration;
import com.atlassian.mywork.service.ClientRegistrationService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegistrationServiceImpl
implements LocalRegistrationService,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(LocalRegistrationServiceImpl.class);
    public static final String ID_HOST = "";
    private final Collection<Registration> lazyRegistrations = Lists.newArrayList();
    private final RegistrationDao registrationDao;
    private final ClientRegistrationService clientRegistrationService;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;
    private final SharedData sharedData;
    private final LockedTaskExecutor lockedTaskExecutor;

    public LocalRegistrationServiceImpl(RegistrationDao registrationDao, ClientRegistrationService clientRegistrationService, TransactionTemplate transactionTemplate, EventPublisher eventPublisher, ClusterLockService clusterLockService, SharedDataLookup sharedDataLookup) {
        this.registrationDao = registrationDao;
        this.clientRegistrationService = clientRegistrationService;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.sharedData = sharedDataLookup.getSharedData("registration-service-shared-data");
        this.lockedTaskExecutor = new LockedTaskExecutor((Lock)clusterLockService.getLockForName(this.getClass().getName()));
    }

    public void register(final Iterable<Registration> registrations) {
        this.lockedTaskExecutor.executeUnderLock(new Runnable(){

            @Override
            public void run() {
                LocalRegistrationServiceImpl.this.registerInternal(registrations);
            }
        }, new Supplier<String>(){

            public String get() {
                return "registering " + registrations;
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    private Map<CacheKey, Optional<Date>> lastModifiedCache() {
        return this.sharedData.getMap();
    }

    private void registerInternal(final Iterable<Registration> registrations) {
        if (this.lastModified().isPresent()) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    for (Registration registration : registrations) {
                        LocalRegistrationServiceImpl.this.register(registration, new Date());
                    }
                    return null;
                }
            });
        } else {
            Iterables.addAll(this.lazyRegistrations, registrations);
        }
    }

    @Nonnull
    private Optional<Date> lastModified() {
        Optional<Date> date = this.lastModifiedCache().get((Object)CacheKey.KEY);
        return date == null ? Optional.absent() : date;
    }

    private void setLastModified(Date date) {
        this.lastModifiedCache().put(CacheKey.KEY, (Optional<Date>)Optional.of((Object)DateUtils.truncate((Date)date, (int)13)));
    }

    protected void register(final Registration registration, final Date date) {
        if (registration == null) {
            return;
        }
        this.lockedTaskExecutor.executeUnderLock(new Runnable(){

            @Override
            public void run() {
                LocalRegistrationServiceImpl.this.registerInternal(registration, date);
            }
        }, new Supplier<String>(){

            public String get() {
                return "registering " + registration + " for " + date;
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    private void registerInternal(Registration registration, Date date) {
        Registration old = this.registrationDao.get(registration.getId());
        if (old == null || !old.equals((Object)registration)) {
            this.registrationDao.set(registration);
            this.setLastModified(date);
            this.eventPublisher.publish((Object)new RegistrationChangedEvent(this, registration));
        }
        log.debug("Registered {}", (Object)registration.getAppId());
    }

    @Override
    public Option<Pair<List<Registration>, Date>> getAll(Date ifModifiedSince) {
        Date date = this.getLastModified();
        if (ifModifiedSince.compareTo(date) < 0) {
            return Option.some((Object)Pair.pair(this.registrationDao.getAll(), (Object)date));
        }
        return Option.none();
    }

    @Override
    public Date getLastModified() {
        Optional<Date> last = this.lastModified();
        if (last.isPresent()) {
            return (Date)last.get();
        }
        return this.lockedTaskExecutor.executeUnderLock(new Callable<Date>(){

            @Override
            public Date call() {
                return LocalRegistrationServiceImpl.this.getLastModifiedInternal();
            }
        }, (Supplier<String>)Suppliers.ofInstance((Object)"getting last modified date"), 5000L, TimeUnit.MILLISECONDS);
    }

    private Date getLastModifiedInternal() {
        if (!this.lastModified().isPresent()) {
            Iterables.addAll(this.lazyRegistrations, (Iterable)this.clientRegistrationService.createRegistrations());
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction() {
                    LocalRegistrationServiceImpl.this.setLastModified(LocalRegistrationServiceImpl.this.registrationDao.getMostRecentUpdate());
                    for (Registration registration : LocalRegistrationServiceImpl.this.lazyRegistrations) {
                        LocalRegistrationServiceImpl.this.register(registration, new Date());
                    }
                    return null;
                }
            });
            this.lazyRegistrations.clear();
        }
        return (Date)this.lastModified().get();
    }

    @Override
    public String getCacheValue(Locale locale) {
        return locale.toString() + "-" + this.getLastModified().getTime();
    }

    @EventListener
    public void onGlobalSettingsChangedEvent(GlobalSettingsChangedEvent event) {
        if (!event.getOldDomainName().equals(event.getNewDomainName())) {
            this.register(this.clientRegistrationService.createRegistrations());
        }
    }

    @Override
    public Registration get(Registration.RegistrationId id) {
        return this.registrationDao.get(id);
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void onStop() {
        this.eventPublisher.unregister((Object)this);
    }

    private static enum CacheKey {
        KEY;

    }
}

