AJS.EventQueue = AJS.EventQueue || [];

MW.Notification = Backbone.Model.extend({
    getPrettyTime: function() {
        return MW.getPrettyTime(this.get("created"));
    },

    open: function() {
        this.get('parent').trigger("open", this);
        window.open(this.attributes.url);
    },

    toEventJSON: function() {
        return _.extend(
            MW.pick(this.attributes, 'id', 'globalId', 'status'),
            MW.pick(this.get('parent').attributes, 'application', 'entity', 'action')
        );
    },

    executeInlineAction: function(options) {
        var defaultData = this.getActionData(options.actionName, options.target);
        var data = options.extraData ? _.extend(options.extraData, defaultData): defaultData;
        MW.$.ajax({
                type: 'POST',
                url: MW.contextPath + '/rest/mywork/1/action',
                data: JSON.stringify(data),
                dataType: "json",
                success: options.success,
                error: options.error,
                contentType:'application/json'
        });
    },

    getActionData: function(actionName, target) {
        return {
            'globalId': this.get("globalId"),
            'qualifiedAction': this.get("parent").get("category") + "." + actionName,
            'application': this.get("parent").get("application"),
            'metadata': this.get("metadata"),
            'target': target,
            'id': this.get("id")
        };
    }
});
