/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.host.util;

import com.atlassian.confluence.cluster.shareddata.PluginSharedDataKey;
import com.atlassian.confluence.cluster.shareddata.PluginSharedDataRegistry;
import com.atlassian.confluence.cluster.shareddata.SharedData;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedDataLookup {
    private static final Logger log = LoggerFactory.getLogger(SharedDataLookup.class);
    private static final String PLUGIN_KEY = "com.atlassian.mywork.mywork-confluence-host-plugin";
    private final PluginSharedDataRegistry sharedDataRegistry;

    public SharedDataLookup(PluginSharedDataRegistry sharedDataRegistry) {
        this.sharedDataRegistry = sharedDataRegistry;
    }

    private PluginSharedDataKey sharedDataKey(String moduleKey) {
        return new PluginSharedDataKey(PLUGIN_KEY, (String)Preconditions.checkNotNull((Object)moduleKey, (Object)"moduleKey has not yet been set - cannot calculate shared data key"));
    }

    public SharedData getSharedData(String sharedDataName) {
        PluginSharedDataKey sharedDataKey = this.sharedDataKey(sharedDataName);
        log.debug("Fetching shared data for [{}]", (Object)sharedDataKey);
        return this.sharedDataRegistry.getPluginSharedData(sharedDataKey);
    }
}

