/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.owasp.validator.html.model.Attribute;

public class Tag {
    private HashMap allowedAttributes = new HashMap();
    private String name;
    private String action;
    private boolean allowEmpty;
    private boolean allowCData;
    private static final String ANY_NORMAL_WHITESPACES = "(\\s)*";
    private static final String OPEN_ATTRIBUTE = "(";
    private static final String ATTRIBUTE_DIVIDER = "|";
    private static final String CLOSE_ATTRIBUTE = ")";
    private static final String OPEN_TAG_ATTRIBUTES = "(\\s)*(";
    private static final String CLOSE_TAG_ATTRIBUTES = ")*";
    private static final String REGEXP_CHARACTERS = "\\(){}.*?$^-+";

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowCData() {
        return this.allowCData;
    }

    public void setAllowCData(boolean allowCData) {
        this.allowCData = allowCData;
    }

    public Tag(String name) {
        this.name = name;
    }

    public void addAttribute(Attribute attr) {
        this.allowedAttributes.put(attr.getName().toLowerCase(), attr);
    }

    public String getRegularExpression() {
        if (this.allowedAttributes.size() == 0) {
            return "^<" + this.name + ">$";
        }
        StringBuffer regExp = new StringBuffer("<(\\s)*" + this.name + OPEN_TAG_ATTRIBUTES);
        Iterator attributes = this.allowedAttributes.keySet().iterator();
        while (attributes.hasNext()) {
            Attribute attr = (Attribute)this.allowedAttributes.get((String)attributes.next());
            regExp.append(attr.getName() + ANY_NORMAL_WHITESPACES + "=" + ANY_NORMAL_WHITESPACES + "\"" + OPEN_ATTRIBUTE);
            Iterator allowedValues = attr.getAllowedValues().iterator();
            Iterator allowedRegExps = attr.getAllowedRegExp().iterator();
            if (attr.getAllowedRegExp().size() + attr.getAllowedValues().size() <= 0) continue;
            while (allowedValues.hasNext()) {
                String allowedValue = (String)allowedValues.next();
                regExp.append(this.escapeRegularExpressionCharacters(allowedValue));
                if (!allowedValues.hasNext() && !allowedRegExps.hasNext()) continue;
                regExp.append(ATTRIBUTE_DIVIDER);
            }
            while (allowedRegExps.hasNext()) {
                Pattern allowedRegExp = (Pattern)allowedRegExps.next();
                regExp.append(allowedRegExp.pattern());
                if (!allowedRegExps.hasNext()) continue;
                regExp.append(ATTRIBUTE_DIVIDER);
            }
            if (attr.getAllowedRegExp().size() + attr.getAllowedValues().size() > 0) {
                regExp.append(CLOSE_ATTRIBUTE);
            }
            regExp.append("\"(\\s)*");
            if (!attributes.hasNext()) continue;
            regExp.append(ATTRIBUTE_DIVIDER);
        }
        regExp.append(")*(\\s)*>");
        return regExp.toString();
    }

    private String escapeRegularExpressionCharacters(String allowedValue) {
        String toReturn = allowedValue;
        if (toReturn == null) {
            return null;
        }
        for (int i = 0; i < REGEXP_CHARACTERS.length(); ++i) {
            toReturn.replaceAll("\\" + String.valueOf(REGEXP_CHARACTERS.charAt(i)), "\\" + REGEXP_CHARACTERS.charAt(i));
        }
        return toReturn;
    }

    public HashMap getAllowedAttributes() {
        return this.allowedAttributes;
    }

    public void setAllowedAttributes(HashMap allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attribute getAttributeByName(String name) {
        return (Attribute)this.allowedAttributes.get(name);
    }
}

