MW.TaskMainView = MW.TaskMainAbstractView.extend({

    makeTasksSortable: function(){
            //noop - sortable not yet applicable to mobile
    },

    showTaskDetail: function (model) {
        // This method is called by the TaskMainAbstractView when attempting to render the task details.
        // In our case, we'll instead navigate to view content for the page containing the task.
        var metadata = model.get("metadata");
        if (metadata && metadata.contentId){
            ConfluenceMobile.router.navigate("content/view/" + metadata.contentId, true);
        }
    },

    renderEmptyTaskTemplate: function(container){
        container.html(MyWork.Templates.Mobile.noTasks({
            emptyText: AJS.I18n.getText("com.atlassian.mywork.mobile.task.empty")
        }));
    },

    renderEmptyCompletedTemplate: function(container) {
        container.html(MyWork.Templates.Mobile.noTasks({
            emptyText: AJS.I18n.getText("com.atlassian.mywork.mobile.task.completed.empty")
        }));
    },

    renderTemplate: function(container){
        container.append(MyWork.Templates.Mobile.mainTask());
        new MW.Confluence.Mobile.HeaderView({
            el: container,
            title: AJS.I18n.getText("com.atlassian.mywork.header.tasks")
        }).render();
    },

    showUncompleted: function() {
        this.completed = false;
        this.addTodo();
        $(".view-completed-mobile").toggleClass("selected", false);
        $(".view-uncompleted-mobile").toggleClass("selected", true);
        MW.Router.navigateToTasks();
        return false;
    },

    showCompleted: function() {
        this.completed = true;
        this.addDone();
        $(".view-completed-mobile").toggleClass("selected", true);
        $(".view-uncompleted-mobile").toggleClass("selected", false);
        MW.Router.navigateToCompletedTasks();
        return false;
    },

    disableAddTask: function() {
       //no op
    },

    showCard: function(){
        $("body").removeClass("android-input-hack");
        MW.Router.navigateToTasks();
        this.show(); // shows completed/uncompleted tasks
        MW.CardAnimation.showCard($(".mw-task"), MW.Slide.FROM_LEFT);
        MW.showTaskMainCard();
    }
});


MW.TaskView = MW.TaskAbstractView.extend({

    renderTemplate: function(container, text){
        container.addClass("mw-mobile-entry-item");
        container.html(MyWork.Templates.Mobile.personalTask({text: text}));
    },

    parseTagText: function(text, tagRegex){
        return text; // return as-is - no tags for mobile
    },

    renderTagLozenge: function() {
        // noop
    }
});