package com.atlassian.multitenant.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

/**
 * The multitenant namespace
 */
public class MultiTenantNamespaceHandler extends NamespaceHandlerSupport
{
    public static final String NAMESPACE = "http://atlassian.com/schema/spring/multitenant";

    public void init()
    {
        super.registerBeanDefinitionDecoratorForAttribute("stateful", new MultiTenantStatefulBeanDefinitionDecorator());
        super.registerBeanDefinitionParser("alternative", new MultiTenantAlternativeBeanDefinitionParser());
        super.registerBeanDefinitionDecoratorForAttribute("lazy-loaded", new MultiTenantLazyLoadedBeanDefinitionDecorator());
        super.registerBeanDefinitionParser("bean", new MultiTenantBeanDefinitionParser());
    }
}
