package com.atlassian.multitenant.hibernate;

import java.sql.Driver;

/**
 * Hibernate configuration descriptor
 */
public class HibernateMultiTenantConfig
{
    private final Class<? extends Driver> driverClass;
    private final String databaseUrl;
    private final String username;
    private final String password;
    private final int poolSize;

    public HibernateMultiTenantConfig(final Class<? extends Driver> driverClass, final String databaseUrl,
            final String username, final String password, final int poolSize)
    {
        this.driverClass = driverClass;
        this.databaseUrl = databaseUrl;
        this.username = username;
        this.password = password;
        this.poolSize = poolSize;
    }

    public Class<? extends Driver> getDriverClass()
    {
        return driverClass;
    }

    public String getDatabaseUrl()
    {
        return databaseUrl;
    }

    public String getUsername()
    {
        return username;
    }

    public String getPassword()
    {
        return password;
    }

    public int getPoolSize()
    {
        return poolSize;
    }
}
