package com.atlassian.multitenant.event;

/**
 * Manager for peering event publishers
 */
public interface PeeringEventPublisherManager
{
    /**
     * Publish an event to all peers
     *
     * @param event The event to publish
     */
    void publish(Object event);

    /**
     * Register a peer
     *
     * @param eventPublisher The peer to register
     */
    void register(PeeringEventPublisher eventPublisher);
}
