package com.atlassian.multitenant.config;

import com.atlassian.config.HomeLocator;
import com.atlassian.multitenant.MultiTenantContext;

import javax.servlet.ServletContext;

/**
 * Home locator for multi tenant applications
 */
public class MultiTenantHomeLocator implements HomeLocator
{
    private String configFileName;

    public String getHomePath()
    {
        if (MultiTenantContext.getTenantReference().isSet())
        {
            return MultiTenantContext.getTenantReference().get().getHomeDir();
        }
        else
        {
            // Return the system home directory
            return System.getProperty("atlassian.multitenant.system.home", "system");
        }
    }

    public String getConfigFileName()
    {
        return configFileName;
    }

    public void setConfigFileName(String configFileName)
    {
        this.configFileName = configFileName;
    }

    public void lookupServletHomeProperty(final ServletContext servletContext)
    {
        // No, I don't want to.
    }
}
