package com.atlassian.multitenant.applinks;

import com.atlassian.multitenant.CustomConfigHandler;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 */
public class AppLinksMultiTenantConfigHandler implements CustomConfigHandler<AppLinksMultiTenantConfig>
{
    public Class<AppLinksMultiTenantConfig> getBeanClass()
    {
        return AppLinksMultiTenantConfig.class;
    }

    public AppLinksMultiTenantConfig parse(final Element element)
    {
        Collection<AppLinkConfig> configs = new ArrayList<AppLinkConfig>();
        for (Element applink : (Iterable<Element>) element.elements("applink"))
        {
            String name = applink.attributeValue("name");
            String application = applink.attributeValue("application");
            String url = applink.attributeValue("url");
            Map<String, String> props = new HashMap<String, String>();
            Element properties = applink.element("properties");
            if (properties != null)
            {
                for (Element prop : (Iterable<Element>) properties.elements("property"))
                {
                    props.put(prop.attributeValue("key"), prop.attributeValue("value"));
                }
            }
            AppLinkConfig appLinkConfig = new AppLinkConfig(application, name, url, props);
            configs.add(appLinkConfig);
        }
        return new AppLinksMultiTenantConfig(configs);
    }

    public void writeTo(final Element element, final AppLinksMultiTenantConfig bean)
    {
        for (AppLinkConfig appLinkConfig : bean.getAppLinkConfigs())
        {
            Element appLinkElement = element.addElement("applink");
            appLinkElement.addAttribute("name", appLinkConfig.getName());
            appLinkElement.addAttribute("application", appLinkConfig.getApplication());
            appLinkElement.addAttribute("url", appLinkConfig.getUrl());
            Element propertiesElement = appLinkElement.addElement("properties");
            for (Map.Entry<String, String> property : appLinkConfig.getProperties().entrySet())
            {
                propertiesElement.addElement("property").addAttribute("key", property.getKey())
                        .addAttribute("value", property.getValue());
            }
        }
    }
}
