/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.plugins;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.multitenant.MultiTenantComponentFactory;
import com.atlassian.multitenant.MultiTenantComponentMap;
import com.atlassian.multitenant.MultiTenantCreator;
import com.atlassian.multitenant.MultiTenantDestroyer;
import com.atlassian.multitenant.Tenant;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.hostcontainer.HostContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTenantModuleDescriptorFactory
implements ModuleDescriptorFactory {
    private static final int LIFECYCLE_INTERCEPTOR = 0;
    private static final int TENANT_INTERCEPTOR = 1;
    private static final int GET_MODULE_CLASS_INTERCEPTOR = 2;
    private final ModuleDescriptorFactory target;
    private final HostContainer hostContainer;
    private final EventPublisher eventPublisher;
    private final MultiTenantComponentFactory factory;

    public MultiTenantModuleDescriptorFactory(HostContainer hostContainer, ModuleDescriptorFactory moduleDescriptorFactory, EventPublisher eventPublisher, MultiTenantComponentFactory factory) {
        this.target = moduleDescriptorFactory;
        this.hostContainer = hostContainer;
        this.eventPublisher = eventPublisher;
        this.factory = factory;
    }

    public ModuleDescriptor<?> getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<? extends ModuleDescriptor> moduleDescriptorClazz = this.getModuleDescriptorClass(type);
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(moduleDescriptorClazz);
        enhancer.setCallbackTypes(new Class[]{LifecycleInterceptor.class, LifecycleInterceptor.TenantInterceptor.class, LifecycleInterceptor.GetModuleClassInterceptor.class});
        enhancer.setCallbackFilter((CallbackFilter)ModuleDescriptorCallbackFilter.INSTANCE);
        Class enhancedClass = enhancer.createClass();
        ModuleDescriptor module = (ModuleDescriptor)this.hostContainer.create(enhancedClass);
        if (module instanceof Factory) {
            LifecycleInterceptor interceptor = new LifecycleInterceptor(moduleDescriptorClazz);
            ((Factory)module).setCallbacks(new Callback[]{interceptor, interceptor.getTenantInterceptor(), interceptor.getGetModuleClassInterceptor()});
        }
        return module;
    }

    public Class<? extends ModuleDescriptor> getModuleDescriptorClass(String type) {
        return this.target.getModuleDescriptorClass(type);
    }

    public boolean hasModuleDescriptor(String type) {
        return this.target.hasModuleDescriptor(type);
    }

    private static boolean isInitMethod(Method method) {
        return MultiTenantModuleDescriptorFactory.methodMatches(method, "init", Plugin.class, Element.class);
    }

    private static boolean isEnabledMethod(Method method) {
        return MultiTenantModuleDescriptorFactory.methodMatches(method, "enabled", new Class[0]);
    }

    private static boolean isDisabledMethod(Method method) {
        return MultiTenantModuleDescriptorFactory.methodMatches(method, "disabled", new Class[0]);
    }

    private static boolean isDestoryMethod(Method method) {
        return MultiTenantModuleDescriptorFactory.methodMatches(method, "destroy", Plugin.class);
    }

    private static boolean methodMatches(Method method1, String methodName, Class<?> ... parameterTypes) {
        return method1.getName().equals(methodName) && Arrays.equals(method1.getParameterTypes(), parameterTypes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LifecycleInterceptor<M extends ModuleDescriptor>
    implements MethodInterceptor {
        private final Class<M> moduleDescriptorClass;
        private final MultiTenantComponentMap<M> map;
        private final AbstractModuleDescriptor initedModuleDescriptor;
        private final TenantInterceptor tenantInterceptor = new TenantInterceptor();
        private final GetModuleClassInterceptor getModuleClassInterceptor = new GetModuleClassInterceptor();
        private volatile Element initElement;
        private volatile Plugin plugin;
        private volatile boolean enabled;
        private volatile boolean destroyed;

        private LifecycleInterceptor(Class<M> moduleDescriptorClass) {
            this.moduleDescriptorClass = moduleDescriptorClass;
            this.initedModuleDescriptor = new AbstractModuleDescriptor(){

                public Object getModule() {
                    return null;
                }
            };
            this.map = MultiTenantModuleDescriptorFactory.this.factory.createComponentMapBuilder((MultiTenantCreator)new MultiTenantModuleDescriptorCreator()).setLazyLoad(MultiTenantComponentMap.LazyLoadStrategy.EAGER_LOAD).construct();
            MultiTenantModuleDescriptorFactory.this.eventPublisher.register((Object)this);
        }

        public TenantInterceptor getTenantInterceptor() {
            return this.tenantInterceptor;
        }

        public GetModuleClassInterceptor getGetModuleClassInterceptor() {
            return this.getModuleClassInterceptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (MultiTenantModuleDescriptorFactory.isInitMethod(method)) {
                this.handleInit((Plugin)args[0], (Element)args[1]);
                return null;
            }
            if (MultiTenantModuleDescriptorFactory.isEnabledMethod(method)) {
                this.handleEnabled();
                return null;
            }
            if (MultiTenantModuleDescriptorFactory.isDisabledMethod(method)) {
                this.handleDisabled();
                return null;
            }
            if (MultiTenantModuleDescriptorFactory.isDestoryMethod(method)) {
                this.handleDestroy((Plugin)args[0]);
                return null;
            }
            throw new IllegalStateException(method.getName() + " illegally invoked on MultiTenantModuleDescriptorInterceptor");
        }

        @EventListener
        public void destroy(PluginFrameworkShutdownEvent event) {
            if (!this.destroyed) {
                this.destroy();
            }
        }

        private void destroy() {
            if (this.plugin != null) {
                this.map.destroy();
                this.plugin = null;
                this.enabled = false;
            }
            this.destroyed = true;
            MultiTenantModuleDescriptorFactory.this.eventPublisher.unregister((Object)this);
        }

        private void handleInit(Plugin plugin, Element element) throws Throwable {
            this.initedModuleDescriptor.init(plugin, element);
            this.plugin = plugin;
            this.initElement = element;
            for (ModuleDescriptor md : this.map.getAll()) {
                md.init(plugin, element);
            }
        }

        private void handleEnabled() {
            this.enabled = true;
            for (ModuleDescriptor md : this.map.getAll()) {
                if (!(md instanceof StateAware)) continue;
                ((StateAware)md).enabled();
            }
        }

        private void handleDisabled() {
            if (this.enabled) {
                this.enabled = false;
                this.getModuleClassInterceptor.resetCache();
                for (ModuleDescriptor md : this.map.getAll()) {
                    if (!(md instanceof StateAware)) continue;
                    ((StateAware)md).disabled();
                }
            }
        }

        private void handleDestroy(Plugin plugin) {
            this.destroy();
        }

        public class GetModuleClassInterceptor
        implements MethodInterceptor {
            private volatile Class moduleClass;
            private volatile boolean cached;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (LifecycleInterceptor.this.enabled) {
                    GetModuleClassInterceptor getModuleClassInterceptor = this;
                    synchronized (getModuleClassInterceptor) {
                        if (!this.cached) {
                            try {
                                this.moduleClass = (Class)method.invoke(LifecycleInterceptor.this.map.get(), new Object[0]);
                                this.cached = true;
                            }
                            catch (InvocationTargetException e) {
                                throw e.getCause();
                            }
                        }
                    }
                    return this.moduleClass;
                }
                try {
                    return method.invoke(LifecycleInterceptor.this.map.get(), new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resetCache() {
                GetModuleClassInterceptor getModuleClassInterceptor = this;
                synchronized (getModuleClassInterceptor) {
                    this.cached = false;
                    this.moduleClass = null;
                }
            }
        }

        public class TenantInterceptor
        implements MethodInterceptor {
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                Method methodToInvoke;
                AbstractModuleDescriptor moduleDescriptor;
                if (LifecycleInterceptor.this.destroyed) {
                    moduleDescriptor = LifecycleInterceptor.this.initedModuleDescriptor;
                    try {
                        methodToInvoke = AbstractModuleDescriptor.class.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException("Method invoked on module descriptor after it was destroyed. This is only legal for some methods on AbstractModuleDescriptor.");
                    }
                } else {
                    moduleDescriptor = (ModuleDescriptor)LifecycleInterceptor.this.map.get();
                    methodToInvoke = method;
                }
                try {
                    return methodToInvoke.invoke((Object)moduleDescriptor, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MultiTenantModuleDescriptorCreator
        implements MultiTenantCreator<M>,
        MultiTenantDestroyer<M> {
            private MultiTenantModuleDescriptorCreator() {
            }

            public M create(Tenant tenant) {
                ModuleDescriptor md = (ModuleDescriptor)MultiTenantModuleDescriptorFactory.this.hostContainer.create(LifecycleInterceptor.this.moduleDescriptorClass);
                if (LifecycleInterceptor.this.plugin != null && LifecycleInterceptor.this.initElement != null) {
                    md.init(LifecycleInterceptor.this.plugin, LifecycleInterceptor.this.initElement);
                }
                if (LifecycleInterceptor.this.enabled && md instanceof StateAware) {
                    ((StateAware)md).enabled();
                }
                return md;
            }

            public void destroy(Tenant tenant, M instance) {
                if (LifecycleInterceptor.this.plugin != null) {
                    if (LifecycleInterceptor.this.enabled && instance instanceof StateAware) {
                        ((StateAware)instance).disabled();
                    }
                    instance.destroy(LifecycleInterceptor.this.plugin);
                }
            }
        }
    }

    private static class ModuleDescriptorCallbackFilter
    implements CallbackFilter {
        private static ModuleDescriptorCallbackFilter INSTANCE = new ModuleDescriptorCallbackFilter();

        private ModuleDescriptorCallbackFilter() {
        }

        public int accept(Method method) {
            if (MultiTenantModuleDescriptorFactory.isInitMethod(method) || MultiTenantModuleDescriptorFactory.isDestoryMethod(method) || MultiTenantModuleDescriptorFactory.isEnabledMethod(method) || MultiTenantModuleDescriptorFactory.isDisabledMethod(method)) {
                return 0;
            }
            if (MultiTenantModuleDescriptorFactory.methodMatches(method, "getModuleClass", new Class[0])) {
                return 2;
            }
            return 1;
        }
    }
}

