package com.atlassian.multitenant.spring;

import com.atlassian.multitenant.MultiTenantContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/**
 * Handles beans that should only be configured in a multi tenant context
 */
public class MultiTenantBeanDefinitionParser implements BeanDefinitionParser
{
    private static final String SINGLE_TENANT = "singletenant";
    private static final String MULTI_TENANT = "multitenant";
    private static final String SCOPE_ATTR = "instantiateFor";

    public BeanDefinition parse(final Element element, final ParserContext parserContext)
    {
        boolean single = SINGLE_TENANT.equals(element.getAttribute(SCOPE_ATTR));
        if (MultiTenantContext.isEnabled() ^ single)
        {
            BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(element);
            BeanDefinitionReaderUtils.registerBeanDefinition(holder, parserContext.getRegistry());
            // Fire events
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
            parserContext.registerComponent(componentDefinition);
        }
        // Returning null means these beans can never be used in a nested fashion, which makes sense really.
        return null;
    }
}
