package com.atlassian.multitenant.event;

import com.atlassian.event.api.EventPublisher;

/**
 * Event publisher that peers with other event publishers through a PeeringEventPublisherManager.  This event publisher
 * will keep it's own register of listeners (delegated to the given target), and will publish events to the manager
 */
public class PeeringEventPublisher implements EventPublisher
{
    private final PeeringEventPublisherManager manager;
    private final EventPublisher target;

    public PeeringEventPublisher(final PeeringEventPublisherManager manager, final EventPublisher target)
    {
        this.manager = manager;
        this.target = target;
        manager.register(this);
    }

    public void publish(final Object event)
    {
        manager.publish(event);
    }

    public void register(final Object listener)
    {
        target.register(listener);
    }

    public void unregister(final Object listener)
    {
        target.unregister(listener);
    }

    public void unregisterAll()
    {
        target.unregisterAll();
    }

    public EventPublisher getTarget()
    {
        return target;
    }
}
