/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.impl.datastore;

import com.atlassian.multitenant.Tenant;
import com.atlassian.multitenant.impl.MultiTenantDatastore;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSystemTenantDatastore
implements MultiTenantDatastore {
    private final MultiTenantDatastore delegate;
    private final Tenant systemTenant;

    public DelegatingSystemTenantDatastore(MultiTenantDatastore delegate, Tenant systemTenant) {
        this.delegate = delegate;
        this.systemTenant = systemTenant;
    }

    @Override
    public Tenant get(String name) {
        if (this.systemTenant.getName().equals(name)) {
            return this.systemTenant;
        }
        return this.delegate.get(name);
    }

    @Override
    public Collection<Tenant> getAll() {
        ArrayList<Tenant> results = new ArrayList<Tenant>();
        results.add(this.systemTenant);
        results.addAll(this.delegate.getAll());
        return results;
    }

    @Override
    public Tenant getByHostname(String hostname) {
        if (this.systemTenant.getHostnames().contains(hostname)) {
            return this.systemTenant;
        }
        return this.delegate.getByHostname(hostname);
    }

    @Override
    public void addTenant(Tenant tenant) {
        if (this.systemTenant.getName().equals(tenant.getName())) {
            throw new IllegalArgumentException("Can not add tenant with same name as system tenant");
        }
        this.delegate.addTenant(tenant);
    }

    @Override
    public void removeTenant(Tenant tenant) {
        if (this.systemTenant.getName().equals(tenant.getName())) {
            throw new IllegalArgumentException("Can not remove system tenant");
        }
        this.delegate.removeTenant(tenant);
    }
}

